#!/usr/bin/env python
# coding=UTF-8
import re, urllib2, sys
from urllib2 import URLError

print "=============================="
print "=== Protokoll Schäuble 1.0 ==="
print "=============================="
print
print "Bitte Daten eingeben:"

#================================================
#                    SETTINGS
#================================================
CHANNEL         = 'UG Kommunikation'
MEMBERS         = ['Wheerd', 'kleinD']

START_TIME      = raw_input("Sitzungsanfang: ")
END_TIME        = raw_input("Sitzungsende: ")
SELF            = raw_input("Eigener Name: ")
INPUT_FILE      = open(raw_input("Protokoll-Datei: "), 'r')
OUTPUT_FILE     = open(raw_input("Ausgabe-Datei: "),   'w')

TIME_TOLERANCE  = 5
MAKE_WIKI_LINKS = True
#================================================

START_TIME = map(int, START_TIME.split(':'))
START_TIME = START_TIME[0] * 60 + START_TIME[1]
END_TIME   = map(int, END_TIME.split(':'))
END_TIME   = END_TIME[0]   * 60 + END_TIME[1]

MSG_REGEX = re.compile(r'\[(\d\d?):(\d\d) ([AP]M)?\] (.*)$', re.I)
URL_REGEX = re.compile(r'\w+://\S+(?=[\.,]\s|[\.,]\Z|\s|[)\]>]|\Z)', re.I)

#================================================

def format_time(time):
    hour = time / 60
    min  = time % 60
    
    return '%02d:%02d' % (hour, min)

def time_filter(time):
    start, end   = time
    _start, _end = time
    
    _END_TIME = END_TIME
    
    if start is None:
        _start = START_TIME
    
    if end is None:
        _end = END_TIME
        
    if _start > _end:
        end       += 24
        _END_TIME += 24    
        
    if (_end - _start) < TIME_TOLERANCE:
        return None
        
    if _end <= START_TIME:
        return None
        
    if _start >= _END_TIME:
        return None
        
    if start <= (START_TIME + TIME_TOLERANCE):
        start = None
        
    if end >= (END_TIME - TIME_TOLERANCE):
        end = None
        
    return start, end
    
def filter_times(times):
    times = filter(bool, map(time_filter, times))
    
    if not times:
        return
    
    if len(times) < 2:
        yield times[0]
        
        return
    
    last = times[0]
    
    for time in times[1:]:
        if (time[0] - last[1]) <= TIME_TOLERANCE:
            last = (last[0], time[1])
            
        else:
            yield last
            
    yield last
    
def format_times(times):
    if times[0] is not None:
        if times[1] is not None:
            return 'von %s bis %s' % (format_time(times[0]), format_time(times[1]))
        else:
            return 'ab %s' % format_time(times[0])
    else:
        if times[1] is not None:
            return 'bis %s' % format_time(times[1])
        else:
            return ''
            
def format_user(user):
    user, times = isinstance(user, str) and (user, None) or user
    
    if MAKE_WIKI_LINKS:
        url = 'http://wiki.piratenpartei.de/Spezial:Suche/Benutzer:%s%s' % (user[0].upper(), user[1:])   
        req = urllib2.Request(url)
       
        try:
            opener = urllib2.build_opener()
            f = opener.open(req)
            
            user = '[[%s|%s]]' % (f.url[29:], user)
            
        except URLError, e:
            pass
    
    if times is not None:
        times = ', '.join(map(format_times, times))
        
    else:
        return user
    
    return times == '' and user or '%s (%s)' % (user, times)
                
def format_msg(msg):
    time, user, msg = msg
    
    msg = msg.strip().replace('\n', '\n: ')
    
    return '|[%s]\n| style="text-align:right" |%s:\n|%s\n' % (format_time(time), user, msg)

#===============================================

msgs    = []
links   = []
users   = {SELF: [(None, None)]}
members = {}
guests  = {}
missing = []

print
print "Verarbeite Protokoll..."

for line in INPUT_FILE:
    m = MSG_REGEX.match(line)
    
    if m is None:
        msgs[-1] = (msgs[-1][0], msgs[-1][1], msgs[-1][2] + line)
        
        continue
    
    hour = int(m.group(1))
    min  = int(m.group(2))
    
    if m.group(3) == 'PM':
        hour += 12
        
    time = hour * 60 + min

    msg = m.group(4)
    
    m = re.match(r'From (.*?): (.*)$', msg)
        
    if m:
        msgs.append((time, m.group(1), m.group(2)))
        
        continue
    
    m = re.match(r'To (.*?): (.*)$', msg)
        
    if m and m.group(1) == CHANNEL:
        msgs.append((time, SELF, m.group(2)))
        
        continue
    
    m = re.match(r'(.*) entered channel.', msg)
        
    if m:
        user = m.group(1)
        
        if user in users:
            users[user].append((time, None))
            
        else:
            users[user] = [(time, None)]
        
        continue
        
    m = re.match(r'(.*) left channel.', msg)
        
    if m:
        user = m.group(1)
        
        if user in users:
            users[user][-1] = (users[user][-1][0], time)
            
        else:
            users[user] = [(None, time)]
        
        continue
        
    m = re.match(r'Left server: (.*)\.', msg)
        
    if m:
        user = m.group(1)
        
        if user in users:
            users[user][-1] = (users[user][-1][0], time)
        
        continue

print "%d Nachrichten gefunden." % len(msgs)

print "Verarbeite gefundene Teilnehmer..."

for user, times in users.items():   
    times = list(filter_times(times))

    if len(times) < 1:
        continue
    
    if user in MEMBERS:
        members[user] = list(times)
        
    else:
        guests[user] = list(times)

for member in MEMBERS:    
    if not member in members:
        missing.append(member)

print "Verarbeite Nachrichten..."
for msg in msgs:
    _links = map(lambda x: x.strip(), URL_REGEX.findall(msg[2])) or []
    
    for link in _links:
        if link[:29] == 'http://wiki.piratenpartei.de/':
            links.append('[[%s]]' %  link[29:])
            
        else:
            links.append(link)
            
print "%d Links gefunden." % len(links)

print "Schreibe in Ausgabedatei..."
    
OUTPUT_FILE.write('* Teilnehmer:\n** '+'\n** '.join(map(format_user, members.items())))
OUTPUT_FILE.write('\n* Entschuldigt fehlende Mitglieder:\n**')
OUTPUT_FILE.write('\n* Unentschuldigt fehlende Mitglieder:\n** '+'\n** '.join(map(format_user, missing)))
OUTPUT_FILE.write('\n* Gäste:\n** '+'\n** '.join(map(format_user, guests.items())))
OUTPUT_FILE.write('\n\nLinks:\n* '+'\n* '.join(links))
OUTPUT_FILE.write('\n\nNachrichten:\n{|\n|-\n '+'|-\n'.join(map(format_msg, msgs))+'|}')

print "Fertig!"
